/**
 * Receives message requests from the Events Handler or the RPC sender
 * and sends them to the comSlave.
 * 
 * @author Yoel Gluschnaider
 */
var slaveDemux = (function () 
{
	
	var me = {};
	
	/**
	 * Send a register slave on event message.
	 * @param {String} eventName - the event name.
	 */
	me.registerOnEvent = function (eventName) 
	{
		comSlave.sendMessage( 
		{
			protocol: protocolTypeEnum.event,
			eventCb: 'registerSlave',
			eventName: eventName
		});
	};
	
	/**
	 * Send a unregister slave on event message.
	 * @param {String} eventName - the event name.
	 */
	me.unregisterOnEvent = function (eventName) 
	{
		comSlave.sendMessage( 
		{
			protocol: protocolTypeEnum.event,
			eventCb: 'unregisterSlave',
			eventName: eventName
		});
	};

	/**
	 * Send a request of an RPC.
	 * @param {Object} slaveId - the target slave id.
	 * @param {Object} rpcResponse - the rpc response object.
	 */
	me.sendRpcRequest = function (rpcRequest) 
	{
		comSlave.sendMessage( 
		{
			protocol: protocolTypeEnum.rpc,
			rpcRequest: rpcRequest
		});
	};
	
	return me;
	
})();
